﻿namespace Code6587EN.Ch05.SetupPermissions
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to setup permissions on a Pages Library
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Pages Library
                    var pages = web.Lists["Pages"];

                    // If the Pages Library is inheriting permissions, break inheritance
                    if (!pages.HasUniqueRoleAssignments)
                        pages.BreakRoleInheritance(false);

                    // Enable the Requirement for Content Approval
                    pages.EnableModeration = true;
                    pages.Update();

                    // Get the Default Username as SPMember and SPUser objects
                    var member = web.Users["USERNAME"] as SPMember;
                    var user = web.Users["USERNAME"] as SPUser;

                    // Create the Approver and Contributors groups
                    web.SiteGroups.Add("Pages Approvers", member, user, "These users can approve submissions in the Pages Library");
                    web.SiteGroups.Add("Pages Contributors", member, user, "These users can edit content in the Pages Library");

                    // Get the newly created groups
                    var approvers = web.SiteGroups["Pages Approvers"];
                    var contributors = web.SiteGroups["Pages Contributors"];

                    // Get the Approve and Contibure roles from the Site
                    var roleApprover = web.RoleDefinitions["Approve"];
                    var roleContribute = web.RoleDefinitions["Contribute"];

                    // Assign the Approve role to the Approvers group
                    var assignmentApprove = new SPRoleAssignment(approvers);
                    assignmentApprove.RoleDefinitionBindings.Add(roleApprover);
                    pages.RoleAssignments.Add(assignmentApprove);

                    // Assign the Contribute role to the Contributors group
                    var assignmentContribute = new SPRoleAssignment(contributors);
                    assignmentContribute.RoleDefinitionBindings.Add(roleContribute);
                    pages.RoleAssignments.Add(assignmentContribute);

                    // Update the Pages Library
                    pages.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
